*===============================================================================
/* 1981 Census Special Workplace Statistics 

This .do file brings in detailed industry data for UK regions.

Note: Unitary and county districts matched using Geo Convert

Source:
1981 census - special workplace statistics downloaded from Nomis
==============================================================================*/
clear 
set more off

cd "$insheet_files/UK/"
	
* I. match unitary authorities and county districts to NUTS codes

insheet using "crosswalk_2006_nuts_unitary_authority_county_districts.csv", names 

gen nuts=substr(nutsareas,1,5)
	
collapse (sum) proportion, by(local nuts)

* Drop local regions with only a small share in a second nuts region. 
* This removes all duplicate local nuts observations. 
drop if proportion<=.01 

sort localauthoritydistrictunitaryaut
save "$dta_files/crosswalk_2006_nuts_unitary_authority_county_districts.dta", replace
clear
import excel NSPD_OLDCD_NEWCD.xls, first cellrange(A1:B423) sheet("OSLAUA")

rename OLDGEOGCD localauthoritydistrictunitaryaut 
merge m:1 localauthoritydistrictunitaryaut using /// 
"$dta_files/crosswalk_2006_nuts_unitary_authority_county_districts.dta", nogen

replace nuts = "UKC14" if GEO=="E06000047"
replace nuts = "UKC21" if GEO =="E06000048" 
replace nuts = "UKD62" if GEO =="E06000049"
replace nuts = "UKD63" if GEO == "E06000050"
replace nuts = "UKG22" if GEO =="E06000051"
replace nuts = "UKK30" if GEO =="E06000052"
replace nuts = "UKK30" if GEO =="E06000053"
replace nuts = "UKK15" if GEO =="E06000054"
replace nuts = "UKH24" if GEO =="E06000055"
replace nuts = "UKH25" if GEO =="E06000056"

save "$dta_files/crosswalk_2006_nuts_unitary_authority_county_districts.dta", replace

insheet using "UK_Census_1981_SWS.csv", name clear

rename mnemonic GEOGCD

merge 1:1 GEOGCD using "$dta_files/crosswalk_2006_nuts_unitary_authority_county_districts.dta"

*===============================================================================
* Create variables 
*===============================================================================
foreach var of varlist alldivisionsallofficeworkersmale - v294 {
	quietly destring `var', replace force
}

egen ind_agro = rsum(agricultureforestryandfishingall-v10)

egen ind_energy = rsum(energyandwatersupplyindustriesal-v14)
egen ind_mining = rsum(extractionmanufacturemineralsmet-v18)
egen ind_metals = rsum(metalgoodsvehicleindustriesetcal-v22)
egen ind_other = rsum(othermanufactiuringindustriesall-v26)
egen ind_construction = rsum(construction*)

egen ind_total = rsum(ind_energy-ind_construction)
egen ind_mnfg = rsum(ind_mining ind_metals)

egen serv_commerce = rsum(distributionhotelscateringlrepai-v34)
egen serv_transport = rsum(transportcommunicationallofficew-v38)
egen serv_credit = rsum(bankingfinanceinsuranceleasinget-v42)
egen serv_admin = rsum(publicadministrativenationaldefe - v250)

egen serv_other = rsum(otherservicesallofficeworkersmal-v46)
	replace serv_other = serv_other - serv_admin
egen serv_total = rsum(serv_commerce - serv_other)

egen check = rsum(alldivisionsall*)
egen check2 = rsum(ind_agro ind_total serv_total)
assert check == check2

*10% Sample, multiply by 10 
foreach var of varlist ind_* serv* {
	replace `var' = `var'*10
}

********************************************************************************

drop industryinadequatelydescribedall
drop if nuts==""

collapse (sum) ind* serv*, by(nuts)

tempfile nuts3
save `nuts3.dta'

gen nuts2 = substr(nuts,1,4) 

collapse (sum) ind* serv*, by(nuts2)

rename nuts2 nuts 

tempfile nuts2
save `nuts2.dta'

gen nuts1 = substr(nuts,1,3) 
collapse (sum) ind* serv*, by(nuts1)

rename nuts1 nuts 

tempfile nuts1
save `nuts1.dta'

collapse (sum) ind* serv*

gen nuts = "UK"
append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

********************************************************************************
*NUTS codes are NUTS 2003. Need to convert to NUTS 2006 then to NUTS 2010.

*Code change

replace nuts ="UKM5" if nuts=="UKM1"
replace nuts ="UKM6" if nuts=="UKM4"
replace nuts ="UKD72" if nuts=="UKD52"
replace nuts ="UKD73" if nuts=="UKD53"
replace nuts ="UKD74" if nuts=="UKD54"
replace nuts ="UKM50" if nuts=="UKM10"
replace nuts ="UKM61" if nuts=="UKM41"
replace nuts ="UKM62" if nuts=="UKM42"
replace nuts ="UKM63" if nuts=="UKM43"
replace nuts ="UKM64" if nuts=="UKM44"
replace nuts ="UKM65" if nuts=="UKM45"
replace nuts ="UKM66" if nuts=="UKM46"

*Boundary shifts
replace nuts="UKD6" if nuts=="UKD2"
replace nuts="UKD7" if nuts=="UKD5"
replace nuts="UKD61" if nuts=="UKD21"
replace nuts="UKD71" if nuts=="UKD51"

*3) Splits. Create a composite region of NUTS 2010 codes from NUTS 2006 code. 

*replace nuts = "UKD62&UKD63" if nuts== "UKD22"
replace nuts = "UKE44&UKE45" if nuts== "UKE43"
replace nuts = "UKF24&UKF25" if nuts== "UKF23"
replace nuts = "UKG36&UKG37" if nuts== "UKG34"
replace nuts = "UKG38&UKG39" if nuts== "UKG35"
*replace nuts = "UKH24&UKH25" if nuts== "UKH22"

gen nuts_composite_flag=0 
	*replace nuts_composite_flag=1 if nuts=="UKD62&UKD63"
	replace nuts_composite_flag=1 if nuts=="UKE44&UKE45"
	replace nuts_composite_flag=1 if nuts=="UKF24&UKF25"
	replace nuts_composite_flag=1 if nuts=="UKG36&UKG37"
	replace nuts_composite_flag=1 if nuts=="UKG38&UKG39"
*	replace nuts_composite_flag=1 if nuts=="UKH24&UKH25"

collapse (sum) ind* serv*, by(nuts)
********************************************************************************

save "$dta_files/IC_UK_SWS1981.dta", replace

rm "$dta_files/crosswalk_2006_nuts_unitary_authority_county_districts.dta"
